<?php
require_once __DIR__ . '/db.php';

// Test database connection
echo "<h1>Database Connection Test</h1>";
if ($conn->connect_error) {
    echo "<p style='color: red;'>Connection failed: " . $conn->connect_error . "</p>";
} else {
    echo "<p style='color: green;'>Database connection successful!</p>";
}

// Test student_applications table
echo "<h2>Student Applications Table</h2>";
$result = $conn->query("SELECT COUNT(*) as count FROM student_applications");
$count = $result->fetch_assoc()['count'];
echo "<p>Total students in database: <strong>$count</strong></p>";

// Test search functionality
echo "<h2>Search Test</h2>";
$stmt = $conn->prepare("
    SELECT id, user_id, first_name, last_name, email, area_code, phone_number 
    FROM student_applications 
    WHERE email LIKE ? OR first_name LIKE ? OR last_name LIKE ? 
    ORDER BY first_name, last_name 
    LIMIT 5
");
$search_term = "%a%";
$stmt->bind_param('sss', $search_term, $search_term, $search_term);
$stmt->execute();
$students = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
$stmt->close();

if (empty($students)) {
    echo "<p style='color: orange;'>No students found with search term 'a'</p>";
} else {
    echo "<p style='color: green;'>Found " . count($students) . " students:</p>";
    echo "<ul>";
    foreach ($students as $student) {
        echo "<li>{$student['first_name']} {$student['last_name']} - {$student['email']}</li>";
    }
    echo "</ul>";
}

// Test JSON output
echo "<h2>JSON Output Test</h2>";
header('Content-Type: application/json');
echo json_encode($students);
?>
