<?php
require_once __DIR__ . '/db.php';

echo "<h2>Database Structure Test</h2>";

// Test if tables exist and show their structure
$tables_to_check = ['packages', 'payment_packages', 'student_assignments', 'fee_items', 'application_payments', 'application_packages', 'payment_receipts'];

foreach ($tables_to_check as $table) {
    echo "<h3>Table: $table</h3>";
    
    // Check if table exists
    $result = $conn->query("SHOW TABLES LIKE '$table'");
    if ($result->num_rows > 0) {
        echo "<p style='color: green;'>✅ Table '$table' exists</p>";
        
        // Show table structure
        $structure = $conn->query("DESCRIBE $table");
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th></tr>";
        
        while ($row = $structure->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . $row['Field'] . "</td>";
            echo "<td>" . $row['Type'] . "</td>";
            echo "<td>" . $row['Null'] . "</td>";
            echo "<td>" . $row['Key'] . "</td>";
            echo "</tr>";
        }
        echo "</table><br>";
        
        // Show sample data
        $data = $conn->query("SELECT * FROM $table LIMIT 3");
        if ($data->num_rows > 0) {
            echo "<p><strong>Sample Data:</strong></p>";
            echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
            
            // Show headers
            $headers = array_keys($data->fetch_assoc());
            $data->data_seek(0);
            echo "<tr>";
            foreach ($headers as $header) {
                echo "<th>$header</th>";
            }
            echo "</tr>";
            
            // Show data rows
            while ($row = $data->fetch_assoc()) {
                echo "<tr>";
                foreach ($row as $value) {
                    echo "<td>" . htmlspecialchars($value ?? '') . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        } else {
            echo "<p style='color: orange;'>⚠️ No data in table</p>";
        }
    } else {
        echo "<p style='color: red;'>❌ Table '$table' does not exist</p>";
    }
    echo "<hr>";
}
?>
