<?php
require_once __DIR__ . '/db.php';

header('Content-Type: application/json');

$email = $_GET['email'] ?? '';

if (empty($email)) {
    echo json_encode(['exists' => false]);
    exit();
}

// Check if student exists by email
$stmt = $conn->prepare("SELECT id, first_name, last_name, email, area_code, phone_number, user_id FROM student_applications WHERE email = ?");
$stmt->bind_param('s', $email);
$stmt->execute();
$result = $stmt->get_result();
$student = $result->fetch_assoc();
$stmt->close();

if ($student) {
    echo json_encode([
        'exists' => true,
        'id' => $student['id'],
        'first_name' => $student['first_name'],
        'last_name' => $student['last_name'],
        'email' => $student['email'],
        'area_code' => $student['area_code'],
        'phone_number' => $student['phone_number'],
        'user_id' => $student['user_id']
    ]);
} else {
    echo json_encode(['exists' => false]);
}
?>