<?php
require_once __DIR__ . '/db.php';

$pageTitle = 'Payment Successful - Xander Global Scholars';
include 'header.php';
?>

<div class="page-hero">
    <div class="hero-content">
        <h1><i class="fas fa-check-circle"></i> Payment Successful!</h1>
        <p class="hero-subtitle">Thank you for your payment. Your transaction has been completed successfully.</p>
    </div>
</div>

<div class="page-content">
    <div class="dashboard-container">
        <div class="success-card">
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            
            <div class="success-content">
                <h2>Payment Confirmed</h2>
                <p>Your payment has been processed successfully. A confirmation email has been sent to your registered email address.</p>
                
                <div class="payment-details">
                    <h3><i class="fas fa-receipt"></i> Transaction Details</h3>
                    
                    <?php if (isset($_GET['payment_id'])): ?>
                    <div class="detail-row">
                        <span>Transaction ID:</span>
                        <span><?= htmlspecialchars($_GET['payment_id']) ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <div class="detail-row">
                        <span>Date:</span>
                        <span><?= date('F j, Y, g:i A') ?></span>
                    </div>
                    
                    <div class="detail-row">
                        <span>Status:</span>
                        <span class="status-success">Completed</span>
                    </div>
                </div>
                
                <div class="next-steps">
                    <h3><i class="fas fa-tasks"></i> What's Next?</h3>
                    <ul>
                        <li>Check your email for payment confirmation</li>
                        <li>Save your transaction receipt for future reference</li>
                        <li>Contact our support team if you have any questions</li>
                        <li>Continue with your application process</li>
                    </ul>
                </div>
                
                <div class="action-buttons">
                    <a href="payment.php" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Make Another Payment
                    </a>
                    <a href="index.php" class="btn btn-secondary">
                        <i class="fas fa-home"></i> Return to Home
                    </a>
                    <button onclick="window.print()" class="btn btn-outline">
                        <i class="fas fa-print"></i> Print Receipt
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Support Section -->
        <div class="support-card">
            <div class="support-header">
                <h3><i class="fas fa-headset"></i> Need Help?</h3>
            </div>
            <div class="support-content">
                <p>If you have any questions about your payment or need assistance, our support team is here to help.</p>
                
                <div class="contact-options">
                    <div class="contact-item">
                        <i class="fas fa-envelope"></i>
                        <div>
                            <strong>Email:</strong> support@xanderglobalscholars.com
                        </div>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-phone"></i>
                        <div>
                            <strong>Phone:</strong> +1 (555) 123-4567
                        </div>
                    </div>
                    <div class="contact-item">
                        <i class="fas fa-comments"></i>
                        <div>
                            <strong>Live Chat:</strong> Available Mon-Fri 9 AM - 6 PM EST
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.success-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1);
    padding: 48px;
    text-align: center;
    margin-bottom: 40px;
    border: 1px solid rgba(229, 231, 235, 0.5);
}

.success-icon {
    width: 100px;
    height: 100px;
    border-radius: 50%;
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 3rem;
    margin: 0 auto 32px;
    animation: successPulse 2s ease-in-out;
}

@keyframes successPulse {
    0% { transform: scale(0.8); opacity: 0; }
    50% { transform: scale(1.1); }
    100% { transform: scale(1); opacity: 1; }
}

.success-content h2 {
    font-size: 2rem;
    font-weight: 700;
    color: #1e293b;
    margin-bottom: 16px;
}

.success-content > p {
    font-size: 1.125rem;
    color: #64748b;
    margin-bottom: 40px;
    max-width: 600px;
    margin-left: auto;
    margin-right: auto;
}

.payment-details {
    background: #f8fafc;
    border-radius: 12px;
    padding: 32px;
    margin-bottom: 40px;
    text-align: left;
    max-width: 500px;
    margin-left: auto;
    margin-right: auto;
}

.payment-details h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.detail-row {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    border-bottom: 1px solid #e2e8f0;
    font-size: 1rem;
}

.detail-row:last-child {
    border-bottom: none;
}

.detail-row span:first-child {
    color: #64748b;
    font-weight: 500;
}

.detail-row span:last-child {
    color: #1e293b;
    font-weight: 600;
}

.status-success {
    color: #10b981;
    font-weight: 600;
}

.next-steps {
    text-align: left;
    max-width: 500px;
    margin: 0 auto 40px;
}

.next-steps h3 {
    font-size: 1.25rem;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 16px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.next-steps ul {
    list-style: none;
    padding: 0;
}

.next-steps ul li {
    padding: 8px 0 8px 24px;
    position: relative;
    color: #64748b;
    font-size: 1rem;
}

.next-steps ul li::before {
    content: '✓';
    position: absolute;
    left: 0;
    color: #10b981;
    font-weight: 600;
}

.action-buttons {
    display: flex;
    justify-content: center;
    gap: 16px;
    flex-wrap: wrap;
    margin-top: 40px;
}

.btn-outline {
    background: transparent;
    border: 2px solid #667eea;
    color: #667eea;
}

.btn-outline:hover {
    background: #667eea;
    color: white;
    transform: translateY(-2px);
}

.support-card {
    background: white;
    border-radius: 16px;
    box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1);
    overflow: hidden;
    border: 1px solid rgba(229, 231, 235, 0.5);
}

.support-header {
    padding: 24px 32px;
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    text-align: center;
}

.support-header h3 {
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 12px;
}

.support-content {
    padding: 32px;
    text-align: center;
}

.support-content p {
    color: #64748b;
    margin-bottom: 24px;
    font-size: 1rem;
}

.contact-options {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 24px;
}

.contact-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px;
    background: #f8fafc;
    border-radius: 8px;
    text-align: left;
}

.contact-item i {
    width: 20px;
    color: #667eea;
    font-size: 1.125rem;
}

.contact-item strong {
    color: #1e293b;
    display: block;
    margin-bottom: 4px;
}

.contact-item span {
    color: #64748b;
    font-size: 0.875rem;
}

@media (max-width: 768px) {
    .success-card {
        padding: 32px 20px;
    }
    
    .success-icon {
        width: 80px;
        height: 80px;
        font-size: 2.5rem;
        margin-bottom: 24px;
    }
    
    .success-content h2 {
        font-size: 1.5rem;
    }
    
    .payment-details {
        padding: 24px 20px;
    }
    
    .action-buttons {
        flex-direction: column;
        align-items: center;
    }
    
    .btn {
        width: 100%;
        max-width: 300px;
        justify-content: center;
    }
    
    .contact-options {
        grid-template-columns: 1fr;
    }
}
</style>

<?php include 'footer.php'; ?>
