<?php
$cards = [
  [
    'id'=>'admissions',
    'icon'=>'🎓',
    'title'=>'Study & Work Abroad',
    'subtitle'=>'Universities, jobs, visas – all in one place',
    'description'=>'Comprehensive support for your international education and career journey. We guide you through university applications, work visa processes, and provide expert advisor support every step of the way. Our team ensures you have access to top-tier institutions and employment opportunities worldwide.',
    'points'=>[
      'University applications',
      'Work visa support',
      'Real advisor guidance'
    ],
    'form'=>'student-application.php'
  ],
  [
    'id'=>'scholarships',
    'icon'=>'💰',
    'title'=>'Scholarships & Loans',
    'subtitle'=>'Funding solutions tailored to your needs',
    'description'=>'Access financial assistance programs designed to make your education affordable. We offer scholarships up to 90% coverage, education loans for Canada and USA, and comprehensive financial planning to help you achieve your academic goals without financial stress.',
    'points'=>[
      'Up to 90% scholarships',
      'Education loans (Canada & USA)',
      'Financial planning support'
    ],
    'form'=>'master-loan.php'
  ],
  [
    'id'=>'i20',
    'icon'=>'📄',
    'title'=>'I-20 Application',
    'subtitle'=>'Fast processing for US institutions',
    'description'=>'Streamlined I-20 application process for US educational institutions. Our SEVIS-compliant system ensures fast processing, seamless university coordination, and comprehensive interview preparation to maximize your chances of approval.',
    'points'=>[
      'SEVIS compliant',
      'University coordination',
      'Interview readiness'
    ],
    'form'=>'form-20.php'
  ],
  [
    'id'=>'credit',
    'icon'=>'🔁',
    'title'=>'Credit Transfer',
    'subtitle'=>'Transfer credits to partner universities',
    'description'=>'Maximize your academic progress by transferring credits from your current institution to our partner universities. Our expert team handles transcript evaluation, course equivalency assessment, and helps reduce your overall study duration while maintaining academic quality.',
    'points'=>[
      'Transcript evaluation',
      'Course equivalency',
      'Reduced study duration'
    ],
    'form'=>'credit_transfer.php'
  ],
  [
    'id'=>'visa',
    'icon'=>'✈️',
    'title'=>'Visa Application',
    'subtitle'=>'Study & visit visas with full guidance',
    'description'=>'Complete visa application support for study and visit purposes. We assist with comprehensive document preparation, conduct mock interviews, and provide expert guidance to achieve a high approval rate. Our proven track record speaks for itself.',
    'points'=>[
      'Document preparation',
      'Mock interviews',
      'High approval rate'
    ],
    'form'=>'visa.php'
  ],
  [
    'id'=>'jobs',
    'icon'=>'💼',
    'title'=>'Apply for Job',
    'subtitle'=>'Work opportunities across Europe',
    'description'=>'Launch your international career with our comprehensive job placement services across Europe. We provide job placement support, accommodation assistance, and airport pickup services to ensure a smooth transition to your new professional environment.',
    'points'=>[
      'Job placement support',
      'Accommodation assistance',
      'Airport pickup'
    ],
    'form'=>'job-application.php'
  ],
  [
    'id'=>'airticket',
    'icon'=>'🛫',
    'title'=>'Airticketing Reservation',
    'subtitle'=>'Flight bookings for students & professionals',
    'description'=>'Hassle-free international and domestic flight booking. Get exclusive student and academic fares, flexible change options, and expert travel support as part of your educational or career journey.',
    'points'=>[
      'Exclusive student/academic fares',
      'Flexible change & cancellation',
      'End-to-end travel support'
    ],
    'form'=>'air-ticket-reservation.php'
  ]
];
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description" content="Xander Global Scholars - Your complete journey to international education and career success. Study abroad, scholarships, visas, and job opportunities.">
<title>Xander Global Scholars - Your Complete Journey to Success</title>

<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
/* =========================================================
   PRODUCTION-READY INDEX PAGE - MODERN UI/UX
   Logo Colors: Dark Blue & Golden Orange
========================================================= */
:root {
  /* Logo Colors */
  --primary: #1e3a5f;
  --primary-dark: #0f2542;
  --primary-light: #2d4f7c;
  --accent: #ff8c42;
  --accent-dark: #e6732f;
  --accent-light: #ffa366;
  
  /* Neutral Colors */
  --bg: #f8fafc;
  --bg-light: #ffffff;
  --card: #ffffff;
  --text: #1e293b;
  --text-light: #64748b;
  --text-muted: #94a3b8;
  --muted: #64748b;
  --border: #e2e8f0;
  --border-light: #f1f5f9;
  
  /* Shadows */
  --shadow-sm: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
  --shadow-md: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
  --shadow-lg: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
  --shadow-xl: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
  
  /* Transitions */
  --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

* {
  box-sizing: border-box;
  margin: 0;
  padding: 0;
}

body {
  margin: 0;
  font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
  background: var(--bg);
  color: var(--text);
  line-height: 1.6;
  -webkit-font-smoothing: antialiased;
  -moz-osx-font-smoothing: grayscale;
}

/* ===== HEADER ===== */
header {
  background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
  padding: 20px 32px;
  display: flex;
  align-items: center;
  justify-content: center;
  box-shadow: var(--shadow-lg);
  position: sticky;
  top: 0;
  z-index: 1000;
  border-bottom: 3px solid var(--accent);
}

/* Replace the header-container styles and add new smart header alignment */
/* ...existing variables... */

.header-container {
  max-width: 1400px;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: space-between;
  gap: 32px;
  position: relative;
}
.header-logo-brand {
  display: flex;
  align-items: center;
  gap: 22px;
  min-width: 300px;
  flex-shrink: 0;
}

.header-logo-brand img {
  height: 96px; /* Increased size */
  width: auto;
  filter: drop-shadow(0 4px 8px rgba(0, 0, 0, 0.2));
  transition: var(--transition);
}
.header-logo-brand img:hover {
  transform: scale(1.08);
  filter: drop-shadow(0 6px 14px rgba(0, 0, 0, 0.3));
}
.brand {
  color: #fff;
  font-weight: 800;
  font-size: 1.7rem;
  letter-spacing: -0.02em;
  text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
  white-space: nowrap;
}

nav {
  display: flex;
  gap: 36px;
  align-items: center;
  justify-content: center;
  flex: 1;
  position: relative;
}

.get-started-standalone {
  background: linear-gradient(135deg, var(--accent) 0%, var(--accent-dark) 100%);
  color: #fff;
  padding: 16px 36px;
  border-radius: 14px;
  text-decoration: none;
  font-weight: 800;
  font-size: 1.12rem;
  transition: var(--transition);
  box-shadow: 0 6px 18px rgba(255, 140, 66, 0.42);
  letter-spacing: 0.03em;
  margin-left: auto;
  margin-right: 0;
  white-space: nowrap;
  position: relative;
  z-index: 2;
}
.get-started-standalone:hover {
  background: linear-gradient(135deg, var(--accent-light) 0%, var(--accent) 100%);
  transform: translateY(-4px) scale(1.05);
  box-shadow: 0 12px 28px rgba(255,140,66,0.48);
}

.mobile-menu-toggle {
  display: none;
  /* ...unchanged... */
}

/* Responsive: Make room for big logo, stack smartly on mobile */
@media (max-width: 1024px) {
  .header-logo-brand img {
    height: 74px;
  }
  .brand {
    font-size: 1.18rem;
  }
}
@media (max-width: 820px) {
  .header-logo-brand img {
    height: 54px !important;
  }
}
@media (max-width: 768px) {
  .header-container {
    flex-wrap: wrap;
    gap: 12px;
  }
  .header-logo-brand {
    min-width: 140px;
    gap: 10px;
  }
  .brand {
    font-size: 1rem;
  }
  .get-started-standalone {
    padding: 10px 18px;
    font-size: 0.94rem;
    margin: 12px 0 0 0;
    border-radius: 9px;
  }
  nav {
    display: none;
    position: absolute;
    top: 100%;
    left: 0; right: 0;
    background: var(--primary-dark);
    flex-direction: column;
    align-items: center;
    padding: 28px 0;
    gap: 24px;
    z-index: 1;
    box-shadow: var(--shadow-lg);
    border-top: 2px solid var(--accent);
  }
  nav.active {
    display: flex;
  }
  .mobile-menu-toggle {
    display: block;
    position: relative;
    z-index: 3;
    margin-left: 12px;
  }
}
@media (max-width: 480px) {
  .header-logo-brand img {
    height: 34px !important;
  }
  .brand {
    font-size: 0.82rem;
  }
  .get-started-standalone {
    font-size: 0.86rem;
    padding: 8px 11px;
  }
}
/* ===== HERO ===== */
.hero {
  text-align: center;
  padding: 100px 20px 80px;
  background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 30%, #f8fafc 60%, #eef2f7 100%);
  background-image: 
    radial-gradient(circle at 15% 25%, rgba(30, 58, 95, 0.08) 0%, transparent 45%),
    radial-gradient(circle at 85% 75%, rgba(255, 140, 66, 0.08) 0%, transparent 45%),
    radial-gradient(circle at 50% 50%, rgba(30, 58, 95, 0.03) 0%, transparent 60%);
  position: relative;
  overflow: hidden;
}

.hero::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  background: 
    linear-gradient(45deg, transparent 30%, rgba(255, 140, 66, 0.02) 50%, transparent 70%),
    linear-gradient(-45deg, transparent 30%, rgba(30, 58, 95, 0.02) 50%, transparent 70%);
  pointer-events: none;
}

.hero h1 {
  font-size: 3.5rem;
  font-weight: 900;
  margin-bottom: 24px;
  background: linear-gradient(135deg, var(--primary) 0%, var(--primary-light) 50%, var(--accent) 100%);
  -webkit-background-clip: text;
  -webkit-text-fill-color: transparent;
  background-clip: text;
  letter-spacing: -0.03em;
  line-height: 1.1;
  position: relative;
  z-index: 1;
}

.hero p {
  max-width: 850px;
  margin: 0 auto;
  font-size: 1.25rem;
  color: var(--text-light);
  line-height: 1.8;
  font-weight: 400;
  position: relative;
  z-index: 1;
}

/* ===== GRID ===== */
.grid {
  max-width: 1400px;
  margin: 0 auto;
  padding: 60px 20px 100px;
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(380px, 1fr));
  gap: 32px;
}

.card {
  background: var(--card);
  border-radius: 20px;
  padding: 32px;
  box-shadow: var(--shadow-lg);
  transition: var(--transition);
  border: 1px solid var(--border-light);
  position: relative;
  overflow: hidden;
}

.card::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 4px;
  background: linear-gradient(90deg, var(--primary) 0%, var(--accent) 100%);
  transform: scaleX(0);
  transition: transform 0.3s ease;
}

.card:hover::before {
  transform: scaleX(1);
}

.card:hover {
  transform: translateY(-8px);
  box-shadow: var(--shadow-xl);
}

.icon {
  width: 64px;
  height: 64px;
  border-radius: 16px;
  background: linear-gradient(135deg, rgba(30, 58, 95, 0.1) 0%, rgba(255, 140, 66, 0.1) 100%);
  display: flex;
  align-items: center;
  justify-content: center;
  font-size: 28px;
  margin-bottom: 20px;
  transition: var(--transition);
}

.card:hover .icon {
  transform: scale(1.1) rotate(5deg);
}

.card h3 {
  margin: 0 0 8px 0;
  font-size: 1.5rem;
  font-weight: 700;
  color: var(--text);
  letter-spacing: -0.01em;
}

.card .subtitle {
  font-size: 1rem;
  color: var(--text-light);
  margin-bottom: 16px;
  font-weight: 500;
}

.card .description {
  font-size: 0.95rem;
  color: var(--text-light);
  line-height: 1.7;
  margin-bottom: 20px;
}

.card ul {
  list-style: none;
  padding: 0;
  margin: 20px 0;
}

.card ul li {
  font-size: 0.9rem;
  margin-bottom: 10px;
  padding-left: 24px;
  position: relative;
  color: var(--text-light);
}

.card ul li::before {
  content: '✓';
  position: absolute;
  left: 0;
  color: var(--accent);
  font-weight: 700;
  font-size: 1rem;
}

.actions {
  display: flex;
  gap: 12px;
  margin-top: 24px;
}

.actions button {
  flex: 1;
  border: none;
  padding: 14px 20px;
  border-radius: 10px;
  cursor: pointer;
  font-weight: 600;
  font-size: 0.95rem;
  transition: var(--transition);
  display: flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
}

.apply {
  background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
  color: #fff;
  box-shadow: 0 4px 12px rgba(30, 58, 95, 0.3);
}

.apply:hover {
  transform: translateY(-2px);
  box-shadow: 0 6px 16px rgba(30, 58, 95, 0.4);
  background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary) 100%);
}

.copy {
  background: var(--bg);
  color: var(--primary);
  border: 2px solid var(--border);
}

.copy:hover {
  background: var(--border-light);
  border-color: var(--primary);
  transform: translateY(-2px);
}

.highlight {
  outline: 3px solid var(--accent);
  outline-offset: 4px;
  animation: pulse 2s infinite;
}

@keyframes pulse {
  0%, 100% { outline-color: var(--accent); }
  50% { outline-color: var(--accent-light); }
}

/* ===== FOOTER ===== */
footer {
  background: linear-gradient(180deg, var(--primary-dark) 0%, var(--primary) 100%);
  color: #fff;
  padding: 0;
  font-size: 0.95rem;
  line-height: 1.8;
  position: relative;
  overflow: hidden;
}

footer::before {
  content: '';
  position: absolute;
  top: 0;
  left: 0;
  right: 0;
  height: 4px;
  background: linear-gradient(90deg, var(--accent) 0%, var(--accent-light) 50%, var(--accent) 100%);
}

.footer-container {
  max-width: 1400px;
  margin: 0 auto;
  padding: 60px 32px 40px;
  display: grid;
  grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
  gap: 40px;
}

.footer-section h3 {
  color: var(--accent);
  font-size: 1.3rem;
  font-weight: 700;
  margin-bottom: 24px;
  letter-spacing: -0.01em;
  position: relative;
  padding-bottom: 12px;
}

.footer-section h3::after {
  content: '';
  position: absolute;
  bottom: 0;
  left: 0;
  width: 50px;
  height: 3px;
  background: var(--accent);
  border-radius: 2px;
}

.footer-section p,
.footer-section li {
  color: rgba(255, 255, 255, 0.9);
  margin-bottom: 12px;
  font-size: 0.95rem;
}

.footer-section ul {
  list-style: none;
  padding: 0;
}

.footer-section ul li {
  margin-bottom: 10px;
  padding-left: 24px;
  position: relative;
}

.footer-section ul li::before {
  content: '→';
  position: absolute;
  left: 0;
  color: var(--accent);
  font-weight: 700;
}

.footer-section a {
  color: rgba(255, 255, 255, 0.9);
  text-decoration: none;
  transition: var(--transition);
  display: inline-flex;
  align-items: center;
  gap: 8px;
}

.footer-section a:hover {
  color: var(--accent-light);
  transform: translateX(4px);
}

.footer-contact-item {
  display: flex;
  align-items: flex-start;
  gap: 12px;
  margin-bottom: 16px;
}

.footer-contact-item i {
  color: var(--accent);
  font-size: 1.2rem;
  margin-top: 4px;
  min-width: 20px;
}

.footer-map {
  width: 100%;
  height: 250px;
  border-radius: 12px;
  overflow: hidden;
  box-shadow: 0 8px 24px rgba(0, 0, 0, 0.3);
  border: 2px solid var(--accent);
  margin-top: 8px;
}

.footer-map iframe {
  width: 100%;
  height: 100%;
  border: none;
}

.social-links {
  display: flex;
  gap: 16px;
  margin-top: 20px;
}

.social-links a {
  width: 44px;
  height: 44px;
  background: rgba(255, 255, 255, 0.1);
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  color: #fff;
  font-size: 1.2rem;
  transition: var(--transition);
  backdrop-filter: blur(10px);
}

.social-links a:hover {
  background: var(--accent);
  transform: translateY(-4px) scale(1.1);
  box-shadow: 0 8px 16px rgba(255, 140, 66, 0.4);
}

.footer-bottom {
  background: rgba(0, 0, 0, 0.2);
  padding: 28px 32px;
  text-align: center;
  border-top: 1px solid rgba(255, 255, 255, 0.1);
}

.footer-bottom p {
  color: rgba(255, 255, 255, 0.8);
  margin: 0;
  font-size: 0.9rem;
}

.footer-bottom a {
  color: var(--accent-light);
  text-decoration: none;
}

.footer-bottom a:hover {
  color: var(--accent);
  text-decoration: underline;
}

/* ===== RESPONSIVE ===== */
@media (max-width: 1024px) {
  .grid {
    grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
    gap: 28px;
  }
}

@media (max-width: 768px) {
  header {
    padding: 16px 20px;
  }

  .header-container {
    flex-wrap: wrap;
  }

  header img {
    height: 56px;
  }

  .brand {
    font-size: 1.1rem;
  }

  nav {
    display: none;
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: var(--primary-dark);
    flex-direction: column;
    padding: 24px 20px;
    gap: 20px;
    box-shadow: var(--shadow-lg);
    border-top: 2px solid var(--accent);
  }

  nav.active {
    display: flex;
  }

  .mobile-menu-toggle {
    display: block;
  }

  .get-started {
    padding: 12px 20px;
    font-size: 0.8rem;
  }

  .hero {
    padding: 70px 20px 50px;
  }

  .hero h1 {
    font-size: 2.2rem;
  }

  .hero p {
    font-size: 1.05rem;
  }

  .grid {
    grid-template-columns: 1fr;
    padding: 40px 20px 60px;
    gap: 24px;
  }

  .card {
    padding: 28px;
  }

  .footer-container {
    grid-template-columns: 1fr;
    gap: 32px;
    padding: 50px 24px 32px;
  }

  .footer-section h3 {
    font-size: 1.2rem;
  }

  .footer-map {
    height: 200px;
  }

  .social-links {
    justify-content: center;
  }

  .footer-bottom {
    padding: 24px 20px;
  }

  .footer-bottom p {
    font-size: 0.85rem;
    line-height: 1.6;
  }
}

@media (max-width: 480px) {
  .header-left img {
    height: 40px;
  }

  .brand {
    font-size: 0.95rem;
  }

  .hero {
    padding: 60px 20px 40px;
  }

  .hero h1 {
    font-size: 1.75rem;
  }

  .actions {
    flex-direction: column;
  }

  .actions button {
    width: 100%;
  }
}
</style>
</head>

<?php include 'header.php'; ?>

<section class="hero">
<h1>What We Do. Your Complete Journey</h1>
<p>Six powerful services seamlessly integrated to ensure your success from application to arrival. Your trusted partner for international education and career opportunities.</p>
</section>

<section class="grid">
<?php foreach($cards as $c): ?>
<div id="<?= $c['id'] ?>" class="card" data-card="<?= $c['id'] ?>" data-form="<?= $c['form'] ?>">
<div class="icon"><?= $c['icon'] ?></div>
<h3><?= $c['title'] ?></h3>
<p class="subtitle"><?= $c['subtitle'] ?></p>
<p class="description"><?= htmlspecialchars($c['description']) ?></p>
<ul>
<?php foreach($c['points'] as $pt): ?>
<li><?= htmlspecialchars($pt) ?></li>
<?php endforeach; ?>
</ul>
<div class="actions">
<button class="apply">
<i class="fas fa-paper-plane"></i>
Apply Now
</button>
<button class="copy">
<i class="fas fa-link"></i>
Copy Link
</button>
</div>
</div>
<?php endforeach; ?>
</section>

<?php include 'footer.php'; ?>
<script>
(function() {
  'use strict';

  // Mobile Menu Toggle
  const mobileMenuToggle = document.getElementById('mobileMenuToggle');
  const mainNav = document.getElementById('mainNav');
  
  if (mobileMenuToggle && mainNav) {
    mobileMenuToggle.addEventListener('click', function() {
      mainNav.classList.toggle('active');
      const icon = mobileMenuToggle.querySelector('i');
      if (icon) {
        icon.classList.toggle('fa-bars');
        icon.classList.toggle('fa-times');
      }
    });

    // Close menu when clicking outside
    document.addEventListener('click', function(e) {
      if (!mainNav.contains(e.target) && !mobileMenuToggle.contains(e.target)) {
        mainNav.classList.remove('active');
        const icon = mobileMenuToggle.querySelector('i');
        if (icon) {
          icon.classList.add('fa-bars');
          icon.classList.remove('fa-times');
        }
      }
    });
  }

  // User ID Management
  function getUserId() {
    let id = sessionStorage.getItem('user_id');
    if (!id) {
      id = 'user-' + Date.now() + '-' + Math.floor(Math.random() * 10000);
      sessionStorage.setItem('user_id', id);
    }
    return id;
  }

  /* =========================
   APPLY NOW BUTTON HANDLER
========================= */
document.querySelectorAll('.apply').forEach(button => {

  button.addEventListener('click', function (e) {
    e.preventDefault();

    const card = this.closest('.card');
    if (!card) {
      console.error('Apply button not inside .card');
      return;
    }

    const form = card.dataset.form;
    const type = card.dataset.card;

    if (!form || !type) {
      alert('Invalid application configuration.');
      console.error('Missing data-form or data-card', card);
      return;
    }

    const userId = getUserId();
    if (!userId) {
      alert('Failed to generate session ID.');
      return;
    }

    let targetUrl = '';

    switch (type) {
      case 'scholarships':
        targetUrl = `loan-providers.php?form=${encodeURIComponent(form)}&id=${encodeURIComponent(userId)}`;
        break;

      case 'visa':
        targetUrl = `select-country.php?form=${encodeURIComponent(form)}&id=${encodeURIComponent(userId)}`;
        break;

      case 'i20':
        targetUrl = `select-20.php?form=${encodeURIComponent(form)}&id=${encodeURIComponent(userId)}`;
        break;

      default:
        targetUrl = `${form}?id=${encodeURIComponent(userId)}`;
    }

    // Optional debug (disable in prod)
    console.debug('[Apply]', { type, form, userId, targetUrl });

    window.location.href = targetUrl;
  });

});

  // Copy Link Button Handler
  document.querySelectorAll('.copy').forEach(btn => {
    btn.addEventListener('click', function() {
      const card = btn.closest('.card');
      const url = `${location.origin}${location.pathname}?card=${card.dataset.card}`;
      
      // Modern clipboard API with fallback
      if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(url).then(function() {
          showNotification('Link copied to clipboard!');
        }).catch(function() {
          fallbackCopy(url);
        });
      } else {
        fallbackCopy(url);
      }
    });
  });

  // Fallback copy method
  function fallbackCopy(text) {
    const textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();
    try {
      document.execCommand('copy');
      showNotification('Link copied to clipboard!');
    } catch (err) {
      showNotification('Failed to copy link. Please copy manually: ' + text);
    }
    document.body.removeChild(textarea);
  }

  // Notification function
  function showNotification(message) {
    // Remove existing notification if any
    const existing = document.querySelector('.notification');
    if (existing) {
      existing.remove();
    }

    const notification = document.createElement('div');
    notification.className = 'notification';
    notification.textContent = message;
    notification.style.cssText = `
      position: fixed;
      top: 20px;
      right: 20px;
      background: var(--primary);
      color: white;
      padding: 16px 24px;
      border-radius: 8px;
      box-shadow: 0 4px 12px rgba(0,0,0,0.15);
      z-index: 10000;
      animation: slideIn 0.3s ease;
      font-weight: 500;
    `;
    document.body.appendChild(notification);

    setTimeout(function() {
      notification.style.animation = 'slideOut 0.3s ease';
      setTimeout(function() {
        notification.remove();
      }, 300);
    }, 3000);
  }

  // Card Highlighting from URL Parameter
  (function() {
    const id = new URLSearchParams(location.search).get('card');
    if (!id) return;
    
    document.querySelectorAll('.card').forEach(c => {
      if (c.id !== id) {
        c.style.display = 'none';
      } else {
        c.classList.add('highlight');
        // Smooth scroll to highlighted card
        setTimeout(function() {
          c.scrollIntoView({ behavior: 'smooth', block: 'center' });
        }, 100);
      }
    });
  })();

  // Add slide animations
  const style = document.createElement('style');
  style.textContent = `
    @keyframes slideIn {
      from {
        transform: translateX(100%);
        opacity: 0;
      }
      to {
        transform: translateX(0);
        opacity: 1;
      }
    }
    @keyframes slideOut {
      from {
        transform: translateX(0);
        opacity: 1;
      }
      to {
        transform: translateX(100%);
        opacity: 0;
      }
    }
  `;
  document.head.appendChild(style);
})();
</script>

</body>
</html>







